﻿using System;
using System.Windows.Forms;
using RDR2;
using RDR2.UI;
using RDR2.Native;
using RDR2.Math;

namespace HCL_Superpower_03
{
    public class Main : Script
    {
/// ///CUSTOM////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// ==Controls: Keys can be set to any keys beside Alt, Control or Shift =======================================================================================================================================
        Keys TKSwitchKey = Keys.Q;  // Press this key to switch the telekinesis. Hold Shift and press this key to switch stasis.
        Keys BlinkKey = Keys.X;  // Press this key to blink.
        Keys TKPin1Key = Keys.D1;  // Hold this key to shoot continuous telekinesis pins. During telekinesis, hold this key to push the target away from the player.
        Keys TKPin2Key = Keys.D2;  // Press this key to shoot a single telekinesis pin. During telekinesis, hold this key to pull the tatget toward the player.
        Keys PKKillKey = Keys.D3;  // Press this key to create a small fire explosion, or during telekinesis, throw the target and stop telekinesis.
        Keys PKEXPKey = Keys.D4;  // Press this key to create a big fire explosion, or during telekinesis, explode the target and stop telekinesis.
        Keys IncreaseKey1 = Keys.F11;  // Hold this key while holding the blink key to increase blink distance. 
        Keys DecreaseKey1 = Keys.F12;  // Hold this key while holding the blink key to decrease blink distance.
        Keys IncreaseKey2 = Keys.F9;  // Hold this key while holding the PKEXPKey to increase blink distance. 
        Keys DecreaseKey2 = Keys.F10;  // Hold this key while holding the PKEXPKey to decrease blink distance.
/// ===Settings==========================================================================================================================================================================
        float DefaultTPLength = 50.0f; // The blink distance will reset to this value every time you hold the blink key. 
        float MaxTPLength = 50.0f;  // The maximum length of a blink.
        float MinTPLength = 2.5f;  // The minimum Length of a blink.
/// //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        Player player = Game.Player;
        Ped playerPed = Game.Player.Character;
        float TKLength = 2.5f;
        float TPLength = 50.0f;
        float EXPLength = 100.0f;
        bool Gun2Pressed = false;
        bool TKKeyPressed = false;
        bool TPKeyPressed = false;
        bool IMKeyPressed = false;
        bool EXPKeyPressed = false;
        bool CapturingEXP1 = false;
        int CapturingEXP1Num = 0;
        int TKPressTimer = 0;
        Entity TKEntity = null;
        Entity IMEntity = null;
        Entity RayEntity = null;

        public Main()
        {
            KeyDown += OnKeyDown;
            KeyUp += OnKeyUp;
            Tick += OnTick;
            Interval = 1;
        }
/// ==================================================================================================================================================================================
        private void OnTick(object sender, EventArgs e)
        {
            if (CapturingEXP1 && CapturingEXP1Num < 25)
            {
                  CapturingEXP1Num = CapturingEXP1Num + 1;
                  OutputArgument Vct = new OutputArgument();
                  bool Ishitting = Function.Call<bool>(Hash.GET_PED_LAST_WEAPON_IMPACT_COORD, playerPed, Vct);
                  if (Ishitting)
                  {
                            Vector3 Hitcoord = Vct.GetResult<Vector3>();
                            Function.Call(Hash.ADD_EXPLOSION, (Hitcoord.X), (Hitcoord.Y), (Hitcoord.Z), 32, 2.5f, true, false, 0);
                            Function.Call(Hash.ADD_EXPLOSION, (Hitcoord.X), (Hitcoord.Y), (Hitcoord.Z - 0.2f), 32, 1.5f, true, false, 0);
                            CapturingEXP1 = false;
                            CapturingEXP1Num = 0;
                  }
            }
/// ---Screen: show boxes-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
            if (!TPKeyPressed && !TKKeyPressed && !IMKeyPressed && !Function.Call<bool>(Hash.IS_PLAYER_FREE_AIMING, player) && (Game.IsKeyPressed(TKPin1Key) || Game.IsKeyPressed(TKPin2Key) || Game.IsKeyPressed(PKKillKey) || Game.IsKeyPressed(PKEXPKey)))
            {
                  Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.00375, 0.0075, 255, 255, 255, 255); 
                  Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.0025, 0.005, 0, 0, 0, 255); 
            }
            if (TKEntity == null && TKKeyPressed && !TPKeyPressed)
            {
                  Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.00375, 0.0075, 200, 200, 255, 255); 
                  Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.0025, 0.005, 0, 0, 55, 255); 
            }
            if (IMEntity == null && IMKeyPressed && !TPKeyPressed)
            {
                    Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.00375, 0.0075, 190, 255, 190, 255); 
                    Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.0025, 0.005, 0, 60, 0, 255);  
            }
/// ---Screen: adjust bars-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
            if (TPKeyPressed)
            {
                    Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.00375, 0.0075, 235, 180, 255, 255); 
                    Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.0025, 0.005, 40, 0, 60, 255); 
                    Function.Call(Hash.DRAW_RECT, 0.95, 0.65, 0.00375, 0.15, 235, 180, 255, 255); 
                    Function.Call(Hash.DRAW_RECT, 0.95, 0.65, 0.0025, ((0.15 / MaxTPLength) * TPLength), 40, 0, 60, 255); 
                    if (Game.IsKeyPressed(IncreaseKey1) && !Game.IsKeyPressed(DecreaseKey1) && TPLength < MaxTPLength)
                    {
                              TPLength = TPLength + 0.5f;
                    }
                    if (!Game.IsKeyPressed(IncreaseKey1) && Game.IsKeyPressed(DecreaseKey1) && TPLength > MinTPLength)
                    {
                              TPLength = TPLength - 0.5f;
                    }
            }
            if (EXPKeyPressed)
            {
                    Function.Call(Hash.DRAW_RECT, 0.95, 0.65, 0.00375, 0.15, 235, 255, 190, 255); 
                    Function.Call(Hash.DRAW_RECT, 0.95, 0.65, 0.0025, (0.0015 * EXPLength), 40, 60, 0, 255); 
                    if (Game.IsKeyPressed(IncreaseKey2) && !Game.IsKeyPressed(DecreaseKey2) && EXPLength < 100.0f)
                    {
                              EXPLength = EXPLength + 0.75f;
                    }
                    if (!Game.IsKeyPressed(IncreaseKey2) && Game.IsKeyPressed(DecreaseKey2) && EXPLength > 2.5f)
                    {
                              EXPLength = EXPLength - 0.75f;
                    }
            }
/// ---Continuous casting-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
            if (Gun2Pressed)
            {
                  if (TKPressTimer > 5)
                  {
                           TKPressTimer = 0;
                  }
                  if (TKPressTimer == 0)
                  {
                           Vector3 TargetSpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 1000f, RotToDir(NC_Get_Cam_Rotation()).Y * 1000f, RotToDir(NC_Get_Cam_Rotation()).Z * 1000f);
                           Vector3 TargetPosition = GameplayCamera.Position + TargetSpace;
                           World.ShootBullet(GameplayCamera.Position, TargetPosition, playerPed, 0x20D13FF, 100);
                  }
                  TKPressTimer = TKPressTimer + 1;
            }
/// ---State: telekinesis-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
            if (TKEntity != null)
            {
                     if (World.GetDistance(playerPed.Position, TKEntity.Position) > 200 || (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity) && TKEntity.IsDead))
                     {
                              if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                              {
                                      Function.Call(Hash.SET_PED_GRAVITY, TKEntity, true);
                                      Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, true);
                              }
                             else
                             {
                                      Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, true);
                             }
                             TKEntity = null;
                             TKLength = 2.5f;
                             RDR2.UI.Screen.ShowSubtitle("Telekinesis Off");
                     }
                     else
                     {
                             Function.Call(Hash.DRAW_RECT, 0.95, 0.35, 0.00375, 0.15, 200, 200, 255, 255); 
                             Function.Call(Hash.DRAW_RECT, 0.95, 0.35, 0.0025, (0.00075 * TKLength), 0, 0, 55, 255); 
                             Vector3 AAAA = new Vector3(GameplayCamera.Direction.X * TKLength, GameplayCamera.Direction.Y * TKLength, (GameplayCamera.Direction.Z * TKLength +1f));
                             Vector3 StarPosition = playerPed.Position + AAAA;
                             TKEntity.ApplyForce((StarPosition - TKEntity.Position) * 10f);  
                             Function.Call(Hash.SET_ENTITY_VELOCITY, TKEntity, 0, 0, 0);
                             if (Function.Call<bool>(Hash.IS_PED_HUMAN, TKEntity) && !Function.Call<bool>(Hash.IS_PED_RAGDOLL, TKEntity))
                                         Function.Call(Hash.SET_PED_TO_RAGDOLL, TKEntity, 10, 10, 1, true, true, true);
                             if (Game.IsKeyPressed(TKPin1Key) && TKLength < 200)
                             {
                                        TKLength = TKLength + 0.5f; 
                             }
                             if (Game.IsKeyPressed(TKPin2Key))
                             {
                                        if (Function.Call<bool>(Hash.IS_ENTITY_A_VEHICLE, TKEntity))
                                        {
                                                if (TKLength > 3.5f)
                                                       TKLength = TKLength - 0.5f;
                                        }
                                        else
                                        {
                                                if (TKLength > 1.5f)
                                                       TKLength = TKLength - 0.5f;
                                        }
                             }
                     }
            }
/// ---State: Stasis------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
            if (IMEntity != null)
            {
                     if (World.GetDistance(playerPed.Position, IMEntity.Position) > 200 || (Function.Call<bool>(Hash.IS_ENTITY_A_PED, IMEntity) && IMEntity.IsDead))
                     {
                              IMEntity = null;
                              RDR2.UI.Screen.ShowSubtitle("Stasis Off");
                     }
                     else
                     {
                              Function.Call(Hash.DRAW_RECT, 0.95, 0.35, 0.00375, 0.15, 190, 255, 190, 255); 
                              Function.Call(Hash.DRAW_RECT, 0.95, 0.35, 0.0025, (0.00075 * World.GetDistance(playerPed.Position, IMEntity.Position)), 0, 60, 0, 255); 
                              if (!Function.Call<bool>(Hash.IS_PED_HUMAN, IMEntity) || (!Game.IsKeyPressed(TKPin1Key) && !Game.IsKeyPressed(TKPin2Key)))
                                         Function.Call(Hash.SET_ENTITY_VELOCITY, IMEntity, 0, 0, 0);
                              if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, IMEntity))
                                         Function.Call(Hash.SET_PED_TO_RAGDOLL, IMEntity, 10, 10, 1, true, true, true);
                              if (Game.IsKeyPressed(TKPin1Key) && !Game.IsKeyPressed(TKPin2Key) && World.GetDistance(playerPed.Position, IMEntity.Position) < 200)
                                         IMEntity.ApplyForce((IMEntity.Position - playerPed.Position) * 7.5f);  
                              if (Game.IsKeyPressed(TKPin2Key) && !Game.IsKeyPressed(TKPin1Key) && World.GetDistance(playerPed.Position, IMEntity.Position) > 1)
                                         IMEntity.ApplyForce((playerPed.Position - IMEntity.Position) * 7.5f);  
                     }
            }
        } 
/// ===============================================================================================================================================================================
        private void OnKeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == TKPin1Key && (e.Shift || (!e.Shift &&TKEntity == null)))
            {
                  Gun2Pressed = true;
            }
            if (e.KeyCode == TKSwitchKey && !e.Shift && TKEntity == null && !Function.Call<bool>(Hash.IS_PLAYER_FREE_AIMING, player))
            {
                     TKKeyPressed = true;
            }
            if (e.KeyCode == BlinkKey && !e.Shift && !player.Character.IsInVehicle() && !Function.Call<bool>(Hash.IS_PED_ON_MOUNT, playerPed))
            {
                     TPKeyPressed = true;
            }
            if (e.KeyCode == TKSwitchKey && e.Shift)
            {
                     IMKeyPressed = true;
            }
            if (e.KeyCode == PKEXPKey && (e.Shift || (!e.Shift && TKEntity == null && IMEntity == null)))
            {
                     EXPKeyPressed = true;
            }
        }
/// ==============================================================================================================================================================================
        private void OnKeyUp(object sender, KeyEventArgs e)
        {
/// ---Control of telekinesis--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
            if (e.KeyCode == TKSwitchKey && !e.Shift)
            {
                    if (TKEntity != null || IMEntity != null)
                    {
                             if (TKEntity != null)
                             {
                                    if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                                    {
                                             Function.Call(Hash.SET_PED_GRAVITY, TKEntity, true);
                                             Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, true);
                                    }
                                    else
                                    {
                                             Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, true);
                                    }
                                    TKEntity = null;
                                    TKLength = 2.5f;
                                    RDR2.UI.Screen.ShowSubtitle("Telekinesis Off");
                             }
                             else
                             {
                                    TKEntity = IMEntity;
                                    IMEntity = null;
                                    TKEntity.Detach();
                                    TKLength = World.GetDistance(playerPed.Position, TKEntity.Position);  
                                    if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                                    {
                                             Function.Call(Hash.SET_PED_GRAVITY, TKEntity, false);
                                             if (!Function.Call<bool>(Hash.IS_PED_HUMAN, TKEntity))
                                                        Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, false);
                                    }
                                    else
                                    {
                                             Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, false);
                                    }
                                    RDR2.UI.Screen.ShowSubtitle("Stasis switched to telekinesis.");
                             }                          
                    }
                    else
                    {
                              if (Function.Call<bool>(Hash.IS_PLAYER_FREE_AIMING, player))
                              {
                                         OutputArgument entTarget = new OutputArgument();
                                         bool IsAmining = Function.Call<bool>(Hash.GET_ENTITY_PLAYER_IS_FREE_AIMING_AT, player, entTarget);
                                         if (IsAmining)
                                         {
                                                 TKEntity = entTarget.GetResult<Entity>();
                                                 if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                                                 {
                                                        if (TKEntity.IsDead)
                                                        {
                                                                  TKEntity = null; 
                                                                  RDR2.UI.Screen.ShowSubtitle("You feel sick about moving a dead body.");
                                                        }
                                                        else
                                                        {
                                                                  TKEntity.Detach();
                                                                  TKLength = World.GetDistance(playerPed.Position, TKEntity.Position);  
                                                                  Function.Call(Hash.SET_PED_GRAVITY, TKEntity, false);
                                                                  RDR2.UI.Screen.ShowSubtitle("Telekinesis On");
                                                                  if (!Function.Call<bool>(Hash.IS_PED_HUMAN, TKEntity))
                                                                              Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, false);
                                                        }
                                                 }
                                                 else
                                                 {
                                                         TKEntity.Detach();
                                                         Vector3 EP1 = TKEntity.Position;
                                                         Function.Call(Hash.SET_ENTITY_VELOCITY, TKEntity, 0, 0, (2.0f));
                                                         Wait(50);      
                                                         Vector3 EP2 = TKEntity.Position; 
                                                         Function.Call(Hash.SET_ENTITY_VELOCITY, TKEntity, 0, 0, 0);
                                                         if (EP2 != EP1)
                                                         {
                                                                TKLength = World.GetDistance(playerPed.Position, TKEntity.Position);  
                                                                Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, false);
                                                                RDR2.UI.Screen.ShowSubtitle("Telekinesis On");
                                                         }
                                                         else
                                                         {
                                                                TKEntity = null;           
                                                                RDR2.UI.Screen.ShowSubtitle("You cannot move this object.");                                         
                                                         }  
                                                 }
                                         }
                              }
                              else
                              {
                                          if (RayEntity == null)
                                          {
                                                     Model PlayerModel = new Model(Function.Call<int>(Hash.GET_ENTITY_MODEL, playerPed));
	                                     Function.Call(Hash.REQUEST_MODEL, PlayerModel);
                                                     while (!Function.Call<bool>(Hash.HAS_MODEL_LOADED, PlayerModel))
                                                     {
                                                             Wait(1);
                                                     }
	                                     RayEntity = Function.Call<Ped>(Hash.CREATE_PED, PlayerModel, 0, 0, 0, 1.0, false, false);
                                                     Function.Call(Hash.SET_ENTITY_INVINCIBLE, RayEntity, true);
                                          }
                                          Vector3 RaySpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 100.0f, RotToDir(NC_Get_Cam_Rotation()).Y * 100.0f, RotToDir(NC_Get_Cam_Rotation()).Z * 100.0f);
                                          Vector3 TargetPosition = NC_Get_Cam_Position() + RaySpace;
                                          Function.Call(Hash.SET_ENTITY_VISIBLE, RayEntity, false);
                                          Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, RayEntity, false);
                                          Function.Call(Hash.SET_ENTITY_ROTATION, RayEntity, 0, 0, ((NC_Get_Cam_Rotation()).Z), 2, true); 
                                          Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, TargetPosition.X, TargetPosition.Y, (TargetPosition.Z), true, false, false, false);
                                          Wait(10);
                                          RaycastResult Raycast = World.Raycast(NC_Get_Cam_Position(), RayEntity.Position, IntersectOptions.Everything, playerPed);
                                          Wait(10);
                                          Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, 0, 0, 0, true, false, false, false);
                                          if (Raycast.DitHitEntity && Raycast.HitEntity != playerPed && Raycast.HitEntity != RayEntity) 
                                          {
                                                  TKEntity = Raycast.HitEntity;
                                                  if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                                                  {
                                                         if (TKEntity.IsDead)
                                                         {
                                                                   TKEntity = null; 
                                                                   RDR2.UI.Screen.ShowSubtitle("You feel sick about moving a dead body.");
                                                         }
                                                         else
                                                         {
                                                                   TKEntity.Detach();
                                                                   TKLength = World.GetDistance(playerPed.Position, TKEntity.Position);  
                                                                   Function.Call(Hash.SET_PED_GRAVITY, TKEntity, false);
                                                                   RDR2.UI.Screen.ShowSubtitle("Telekinesis On");
                                                                   if (!Function.Call<bool>(Hash.IS_PED_HUMAN, TKEntity))
                                                                            Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, false);
                                                         }
                                                  }
                                                  else
                                                  {
                                                          TKEntity.Detach();
                                                          Vector3 EP1 = TKEntity.Position;
                                                          Function.Call(Hash.SET_ENTITY_VELOCITY, TKEntity, 0, 0, (2.0f));
                                                          Wait(50);      
                                                          Vector3 EP2 = TKEntity.Position; 
                                                          Function.Call(Hash.SET_ENTITY_VELOCITY, TKEntity, 0, 0, 0);
                                                          if (EP2 != EP1)
                                                          {
                                                                 TKLength = World.GetDistance(playerPed.Position, TKEntity.Position);  
                                                                 Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, false);
                                                                 RDR2.UI.Screen.ShowSubtitle("Telekinesis On");
                                                          }
                                                          else
                                                          {
                                                                 TKEntity = null;           
                                                                 RDR2.UI.Screen.ShowSubtitle("You cannot move this object.");                                         
                                                          }  
                                                  }
                                          }
                              }
                    }
            }
            if (e.KeyCode == PKKillKey && !e.Shift && TKEntity != null)
            {
                             Vector3 TKPosition = playerPed.Position + new Vector3(0, 0, 0.1f);
                             if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                             {
                                      Function.Call(Hash.SET_PED_GRAVITY, TKEntity, true);
                                      Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, true);
                                      if (Function.Call<bool>(Hash.IS_PED_HUMAN, TKEntity) && !Function.Call<bool>(Hash.IS_PED_RAGDOLL, TKEntity))
                                                  Function.Call(Hash.SET_PED_TO_RAGDOLL, TKEntity, 10, 10, 1, true, true, true);
                             }
                             else
                             {
                                      Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, true);
                             }
                             TKEntity.ApplyForce((TKEntity.Position - TKPosition) * 100f / (TKEntity.Position - TKPosition).Length()); 
                             TKEntity = null;
                             TKLength = 2.5f;
                             RDR2.UI.Screen.ShowSubtitle("Telekinesis Off");
            }
            if (e.KeyCode == PKEXPKey && !e.Shift && TKEntity != null)
            {
                     Function.Call(Hash.ADD_EXPLOSION, (TKEntity.Position.X), (TKEntity.Position.Y), (TKEntity.Position.Z), 23, 0.5f, true, false, 0);
                     if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity) && !TKEntity.IsDead)
                     {
                              int Damage =  Function.Call<int>(Hash.GET_ENTITY_MAX_HEALTH, TKEntity) + 1;
                              Function.Call(Hash.APPLY_DAMAGE_TO_PED, TKEntity, Damage, false);
                     }
                     TKEntity = null;
                     TKLength = 2.5f;
                     RDR2.UI.Screen.ShowSubtitle("Telekinesis Off");
            }
/// ---Control of Stasis---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
            if (e.KeyCode == TKSwitchKey && e.Shift)
            {
                    if (TKEntity != null || IMEntity != null)
                    {
                             if (IMEntity != null)
                             {
                                      Function.Call(Hash.SET_ENTITY_VELOCITY, IMEntity, 0, 0, 0);
                                      IMEntity = null;
                                      RDR2.UI.Screen.ShowSubtitle("Stasis Off");
                             }
                             else
                             {
                                      if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity) || Function.Call<bool>(Hash.IS_ENTITY_A_VEHICLE, TKEntity))
                                      {
                                               IMEntity = TKEntity;
                                               if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, IMEntity))
                                               {
                                                         Function.Call(Hash.SET_PED_GRAVITY, IMEntity, true);
                                                         Function.Call(Hash.SET_PED_CAN_RAGDOLL, IMEntity, true);
                                               }
                                               else
                                               {
                                                         Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, IMEntity, true);
                                               }
                                               TKEntity = null;
                                               TKLength = 2.5f;
                                               RDR2.UI.Screen.ShowSubtitle("Telekinesis switched to stasis.");
                                      }
                                      else
                                      {
                                               RDR2.UI.Screen.ShowSubtitle("There is no need to immobilize this object.");
                                      }
                             }
                     }
                     else
                     {
                             if (RayEntity == null)
                             {
                                      Model PlayerModel = new Model(Function.Call<int>(Hash.GET_ENTITY_MODEL, playerPed));
	                      Function.Call(Hash.REQUEST_MODEL, PlayerModel);
                                      while (!Function.Call<bool>(Hash.HAS_MODEL_LOADED, PlayerModel))
                                      {
                                               Wait(1);
                                      }
	                      RayEntity = Function.Call<Ped>(Hash.CREATE_PED, PlayerModel, 0, 0, 0, 1.0, false, false);
                                      Function.Call(Hash.SET_ENTITY_INVINCIBLE, RayEntity, true);
                             }
                             Vector3 RaySpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 100.0f, RotToDir(NC_Get_Cam_Rotation()).Y * 100.0f, RotToDir(NC_Get_Cam_Rotation()).Z * 100.0f);
                             Vector3 TargetPosition = NC_Get_Cam_Position() + RaySpace;
                             Function.Call(Hash.SET_ENTITY_VISIBLE, RayEntity, false);
                             Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, RayEntity, false);
                             Function.Call(Hash.SET_ENTITY_ROTATION, RayEntity, 0, 0, ((NC_Get_Cam_Rotation()).Z), 2, true); 
                             Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, TargetPosition.X, TargetPosition.Y, (TargetPosition.Z), true, false, false, false);
                             Wait(10);
                             RaycastResult Raycast = World.Raycast(NC_Get_Cam_Position(), RayEntity.Position, IntersectOptions.Everything, playerPed);
                             Wait(10);
                             if (Raycast.DitHitEntity) 
                             {
                                    if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, Raycast.HitEntity))
                                    {
                                               if (!Raycast.HitEntity.IsDead)
                                               {
                                                          IMEntity = Raycast.HitEntity;
                                                          RDR2.UI.Screen.ShowSubtitle("Stasis On");
                                               }
                                               else
                                               {
                                                          RDR2.UI.Screen.ShowSubtitle("There is no need to immobilize a dead body.");
                                               }
                                    }
                                    else
                                    {
                                               if (Function.Call<bool>(Hash.IS_ENTITY_A_VEHICLE, Raycast.HitEntity))
                                               {
                                                          IMEntity = Raycast.HitEntity;
                                                          RDR2.UI.Screen.ShowSubtitle("Stasis On");
                                               }
                                               else
                                               {
                                                          RDR2.UI.Screen.ShowSubtitle("There is no need to immobilize this object.");
                                               }
                                    }
                             }
                             Wait(10);
                             Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, 0, 0, 0, true, false, false, false);
                     }
            }
            if (e.KeyCode == PKKillKey && !e.Shift && IMEntity != null)
            {
                     IMEntity.ApplyForce((IMEntity.Position - playerPed.Position) * 100f / (IMEntity.Position - playerPed.Position).Length()); 
                     IMEntity = null;
                     RDR2.UI.Screen.ShowSubtitle("Stasis Off");
            }
            if (e.KeyCode == PKEXPKey && !e.Shift && IMEntity != null)
            {
                     if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, IMEntity))
                     {
                              int Damage =  Function.Call<int>(Hash.GET_ENTITY_MAX_HEALTH, IMEntity) + 1;
                              Function.Call(Hash.APPLY_DAMAGE_TO_PED, IMEntity, Damage, false);
                              if (IMEntity.IsDead)
                              {
                                      IMEntity = null;
                                      RDR2.UI.Screen.ShowSubtitle("Target is destroyed.");
                              }
                     }
                     else
                     {
                              Function.Call(Hash.ADD_EXPLOSION, (IMEntity.Position.X), (IMEntity.Position.Y), (IMEntity.Position.Z), 23, 0.5f, true, false, 0);
                              IMEntity = null;
                              RDR2.UI.Screen.ShowSubtitle("Stasis Off");
                     }
            }
/// ---Telekinetic and pyrokinetic powers-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
            if (e.KeyCode == TKPin2Key && (e.Shift || (!e.Shift && TKEntity == null && IMEntity == null)))
            {
                             Vector3 TargetSpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 1000f, RotToDir(NC_Get_Cam_Rotation()).Y * 1000f, RotToDir(NC_Get_Cam_Rotation()).Z * 1000f);
                             Vector3 TargetPosition = GameplayCamera.Position + TargetSpace;
                             World.ShootBullet(GameplayCamera.Position, TargetPosition, playerPed, 0xE1D2B317, 100);
            }
            if (e.KeyCode == PKKillKey && (e.Shift || (!e.Shift && TKEntity == null && IMEntity == null)))
            {
                  Vector3 TargetSpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 1000f, RotToDir(NC_Get_Cam_Rotation()).Y * 1000f, RotToDir(NC_Get_Cam_Rotation()).Z * 1000f);
                  Vector3 TargetPosition = GameplayCamera.Position + TargetSpace;
                  CapturingEXP1 = true;
                  CapturingEXP1Num = 0;
                  World.ShootBullet(GameplayCamera.Position, TargetPosition, playerPed, 0xE1D2B317, 20);
            }
            if (e.KeyCode == PKEXPKey && (e.Shift || (!e.Shift && TKEntity == null && IMEntity == null)))
            {
                     if (RayEntity == null)
                     {
                              Model PlayerModel = new Model(Function.Call<int>(Hash.GET_ENTITY_MODEL, playerPed));
	              Function.Call(Hash.REQUEST_MODEL, PlayerModel);
                              while (!Function.Call<bool>(Hash.HAS_MODEL_LOADED, PlayerModel))
                              {
                                       Wait(1);
                              }
	              RayEntity = Function.Call<Ped>(Hash.CREATE_PED, PlayerModel, 0, 0, 0, 1.0, false, false);
                              Function.Call(Hash.SET_ENTITY_INVINCIBLE, RayEntity, true);
                     }
                     Vector3 RaySpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 120.0f, RotToDir(NC_Get_Cam_Rotation()).Y * 120.0f, RotToDir(NC_Get_Cam_Rotation()).Z * 120.0f);
                     Vector3 TargetPosition = NC_Get_Cam_Position() + RaySpace;
                     Function.Call(Hash.SET_ENTITY_VISIBLE, RayEntity, false);
                     Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, RayEntity, false);
                     Function.Call(Hash.SET_ENTITY_ROTATION, RayEntity, 0, 0, ((NC_Get_Cam_Rotation()).Z), 2, true); 
                     Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, TargetPosition.X, TargetPosition.Y, (TargetPosition.Z), true, false, false, false);
                     Wait(10);
                     RaycastResult Raycast = World.Raycast(NC_Get_Cam_Position(), RayEntity.Position, IntersectOptions.Everything, playerPed);
                     Wait(10);
                     if (Raycast.DitHit && Raycast.HitPosition != new Vector3(0, 0, 0) && World.GetDistance(playerPed.Position, Raycast.HitPosition) < EXPLength ) 
                     {
                               Function.Call(Hash.ADD_EXPLOSION, (Raycast.HitPosition.X), (Raycast.HitPosition.Y), (Raycast.HitPosition.Z - 0.5f), 32, 6.0f, true, false, 0);
                               Function.Call(Hash.ADD_EXPLOSION, (Raycast.HitPosition.X), (Raycast.HitPosition.Y), (Raycast.HitPosition.Z), 32, 4.5f, true, false, 0);
                     }
                     else
                     {
                               Vector3 AAAA = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * EXPLength, RotToDir(NC_Get_Cam_Rotation()).Y * EXPLength, RotToDir(NC_Get_Cam_Rotation()).Z * EXPLength);
                               Vector3 castcoord = playerPed.Position + AAAA;
                               Function.Call(Hash.ADD_EXPLOSION, (castcoord.X), (castcoord.Y), (castcoord.Z), 32, 6.0f, true, false, 0);
                               Function.Call(Hash.ADD_EXPLOSION, (castcoord.X), (castcoord.Y), (castcoord.Z + 0.5f), 32, 4.5f, true, false, 0);
                     }
                     Wait(10);
                     Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, 0, 0, 0, true, false, false, false);
                     EXPLength = 100.0f;
            }
/// ---Blink power------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
            if (e.KeyCode == BlinkKey && !e.Shift && !player.Character.IsInVehicle() && !Function.Call<bool>(Hash.IS_PED_ON_MOUNT, playerPed))
            {
                     if (RayEntity == null)
                     {
                              Model PlayerModel = new Model(Function.Call<int>(Hash.GET_ENTITY_MODEL, playerPed));
	              Function.Call(Hash.REQUEST_MODEL, PlayerModel);
                              while (!Function.Call<bool>(Hash.HAS_MODEL_LOADED, PlayerModel))
                              {
                                       Wait(1);
                              }
	              RayEntity = Function.Call<Ped>(Hash.CREATE_PED, PlayerModel, 0, 0, 0, 1.0, false, false);
                              Function.Call(Hash.SET_ENTITY_INVINCIBLE, RayEntity, true);
                     }
                     Vector3 RaySpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 100.0f, RotToDir(NC_Get_Cam_Rotation()).Y * 100.0f, RotToDir(NC_Get_Cam_Rotation()).Z * 100.0f);
                     Vector3 TargetPosition = NC_Get_Cam_Position() + RaySpace;
                     Function.Call(Hash.SET_ENTITY_VISIBLE, RayEntity, false);
                     Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, RayEntity, false);
                     Function.Call(Hash.SET_ENTITY_ROTATION, RayEntity, 0, 0, ((NC_Get_Cam_Rotation()).Z), 2, true); 
                     Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, TargetPosition.X, TargetPosition.Y, (TargetPosition.Z), true, false, false, false);
                     Wait(10);
                     RaycastResult Raycast = World.Raycast(NC_Get_Cam_Position(), RayEntity.Position, IntersectOptions.Everything, playerPed);
                     Wait(10);
                     if (Raycast.DitHit && Raycast.HitPosition != new Vector3(0, 0, 0) && World.GetDistance(playerPed.Position, Raycast.HitPosition) < TPLength) 
                     {
                               Vector3 castcoord = Raycast.HitPosition + new Vector3(0, 0, 0.00005f) + new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * (-0.00001f), RotToDir(NC_Get_Cam_Rotation()).Y * (-0.00001f), RotToDir(NC_Get_Cam_Rotation()).Z * (-0.00001f));
                               Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, castcoord.X, castcoord.Y, (castcoord.Z - 10.0f), true, false, false, false);
                               Wait(10);
                               RaycastResult RayTW1 = World.Raycast(castcoord, RayEntity.Position, IntersectOptions.Everything, playerPed);
                               Wait(10);
                               if (RayTW1.DitHit && World.GetDistance(Raycast.HitPosition, RayTW1.HitPosition) < 1.85f)
                               {
                                        Vector3 TW1coord = RayTW1.HitPosition;
                                        Function.Call(Hash.SET_ENTITY_COORDS, playerPed, RayTW1.HitPosition.X, RayTW1.HitPosition.Y, RayTW1.HitPosition.Z, true, false, false, false);
                               } 
                               else
                               {
                                        Function.Call(Hash.SET_ENTITY_COORDS, playerPed, Raycast.HitPosition.X, Raycast.HitPosition.Y, (Raycast.HitPosition.Z - 1.85f), true, false, false, false);
                               }
                     }
                     else
                     {
                               Vector3 AAAA = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * TPLength, RotToDir(NC_Get_Cam_Rotation()).Y * TPLength, RotToDir(NC_Get_Cam_Rotation()).Z * TPLength);
                               Vector3 currentPosition = playerPed.Position;   
                               Vector3 castcoord = currentPosition + AAAA;
                               Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, castcoord.X, castcoord.Y, (castcoord.Z - 10.0f), true, false, false, false);
                               Wait(10);
                               RaycastResult RayTW1 = World.Raycast(castcoord, RayEntity.Position, IntersectOptions.Everything, playerPed);
                               Wait(10);
                               if (RayTW1.DitHit && World.GetDistance(castcoord, RayTW1.HitPosition) < 1.85f)
                               {
                                       Vector3 TW1coord = RayTW1.HitPosition;
                                       Function.Call(Hash.SET_ENTITY_COORDS, playerPed, RayTW1.HitPosition.X, RayTW1.HitPosition.Y,  RayTW1.HitPosition.Z, true, false, false, false);
                               } 
                               else
                               {
                                       Function.Call(Hash.SET_ENTITY_COORDS, playerPed, (currentPosition.X + AAAA.X), (currentPosition.Y + AAAA.Y), (currentPosition.Z + AAAA.Z - 1.85f), true, false, false, false);
                               }    
                     }
                     Wait(10);
                     Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, 0, 0, 0, true, false, false, false);
                     TPLength = DefaultTPLength;
            }
/// ---Reset key pressing-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
            if (e.KeyCode == TKPin1Key && (e.Shift || (!e.Shift &&TKEntity == null)))
            {
                  Gun2Pressed = false;
            }
            if (e.KeyCode == TKSwitchKey && !e.Shift && TKEntity == null && !Function.Call<bool>(Hash.IS_PLAYER_FREE_AIMING, player))
            {
                     TKKeyPressed = false;
            }
            if (e.KeyCode == BlinkKey && !e.Shift && !player.Character.IsInVehicle() && !Function.Call<bool>(Hash.IS_PED_ON_MOUNT, playerPed))
            {
                     TPKeyPressed = false;
            }
            if (e.KeyCode == TKSwitchKey && e.Shift)
            {
                     IMKeyPressed = false;
            }
            if (e.KeyCode == PKEXPKey && (e.Shift || (!e.Shift && TKEntity == null && IMEntity == null)))
            {
                     EXPKeyPressed = false;
            }
            if (e.KeyCode == TKSwitchKey)
            {
                     TKKeyPressed = false;
                     IMKeyPressed = false;
            }
            if (e.KeyCode == TKPin1Key)
            {
                     Gun2Pressed = false;
                     TKPressTimer = 0;
            }
            if (e.KeyCode == BlinkKey)
            {
                     TPKeyPressed = false;
            }
            if (e.KeyCode == PKEXPKey)
            {
                     EXPKeyPressed = false;
            }
        }
/// ===============================================================================
        public Vector3 RotToDir(Vector3 Rot)
        {
            try
            {
                float z = Rot.Z;
                float retz = z * 0.0174532924F;
                float x = Rot.X;
                float retx = x * 0.0174532924F;
                float absx = (float)System.Math.Abs(System.Math.Cos(retx));
                return new Vector3((float)-System.Math.Sin(retz) * absx, (float)System.Math.Cos(retz) * absx, (float)System.Math.Sin(retx));
            }
            catch
            {
                return new Vector3(0, 0, 0);
            }
        }

        public Vector3 NC_Get_Cam_Position()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_COORD);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        }

        public Vector3 NC_Get_Cam_Rotation()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_ROT, 0);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        } 
    }
}
